--------------------------------------------------------------------
--            SymCACP Script Module Find End - variable period
-- Symmetrical CA Control Panel   symCACPscript-1
--file for finding end generation (script2 version)
-- VP os variable period: special version with built in tables
-- to do runFindEnd10-50R_CP_Script to only do the periods and rules needed
-- combines script2-findEndUpdatePop for population of maxEx results
--------------------------------------------------------------------
--  P. Rendell  19/08/2020
--------------------------------------------------------------------

--
-- output 
-- RULE, WD, HT, SEED, GEO, GEN, RUNLEN


------------------------------------------------------------

local scriptType = "script2-findEnd"
local m={}			-- class table
m.cnt = 0
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local gr = require("buildUni") 
local gs = require("search") 
local gsb = require("search-band")
local gsc = require("search-chaos")
m.colonList = {['RULES'] = {"r","R"}, ['SEEDS'] = {"s","R"}, ['GEO'] = {'g',""}}
m.equalList = {['WIDTH0'] = {"d","R"}, ['WIDTH1'] = {"d",""}, ['WIDTHS'] = {"d",""},
               ['LOGFILE'] = {'t',""}, ['RESULTS_OLD'] = {'t',""}, ['RESULTS_NEW'] = {'t',"R"},
               ['STEP1'] = {"d","R"}, ['MAX_OSC'] = {"d","R"}, ['MIN_OSC'] = {"d","R"},
               ['MAX_GEN'] = {'d',"R"}, ['END_TYPE'] = {'t',""},
               ['VERIFY'] = {'l',"R"},['CHECK_MAX_GEN'] = {'l',"R"} }
-- m.ruleData[rule][1]+5 = max WD
-- (m.ruleData[rule][2]*3+3)//4 = max Period
m.ruleData = {
   ["H000"] = {50,1},	["H002"] = {50,1},	["H004"] = {50,1},	["H006"] = {50,1},	["H008"] = {50,6},	["H00A"] = {50,6},
   ["H00C"] = {50,84},	["H00E"] = {50,60},	["H010"] = {35,28},	["H012"] = {0,0},	["H014"] = {0,0},	["H016"] = {0,0},
   ["H018"] = {0,0},	["H01A"] = {0,0},	["H01C"] = {10,3},	["H01E"] = {20,30},	["H020"] = {50,2},	["H022"] = {10,5},	
   ["H024"] = {0,0},	["H026"] = {0,0},	["H028"] = {0,0},	["H02A"] = {0,0},	["H02C"] = {0,0},	["H02E"] = {0,0},	
   ["H030"] = {50,132},	["H032"] = {0,0},	["H034"] = {0,0},	["H036"] = {0,0},	["H038"] = {0,0},	["H03A"] = {0,0},
   ["H03C"] = {50,156},	["H03E"] = {50,168},	["H040"] = {50,1},	["H042"] = {50,60},	["H044"] = {10,2},	["H046"] = {0,0},
   ["H048"] = {0,0},	["H04A"] = {0,0},	["H04C"] = {0,0},	["H04E"] = {0,0},	["H050"] = {50,84},	["H052"] = {0,0},	
   ["H054"] = {10,30},	["H056"] = {0,0},	["H058"] = {0,0},	["H05A"] = {0,0},	["H05C"] = {0,0},	["H05E"] = {20,14},
   ["H060"] = {50,1},	["H062"] = {0,0},	["H064"] = {0,0},	["H066"] = {0,0},	["H068"] = {50,8},	["H06A"] = {0,0},
   ["H06C"] = {0,0},	["H06E"] = {0,0},	["H070"] = {50,4},	["H072"] = {35,120},	["H074"] = {20,20},	["H076"] = {35,10},
   ["H078"] = {50,68},	["H07A"] = {50,60},	["H07C"] = {50,12},	["H07E"] = {50,12},	["H080"] = {50,1},	["H082"] = {50,84},
   ["H084"] = {50,84},	["H086"] = {50,114},	["H088"] = {30,20},	["H08A"] = {25,42},	["H08C"] = {45,186},	["H08E"] = {10,12},
   ["H090"] = {50,168},	["H092"] = {0,0},	["H094"] = {0,0},	["H096"] = {0,0},	["H098"] = {0,0},	["H09A"] = {0,0},
   ["H09C"] = {10,1},	["H09E"] = {25,50},	["H0A0"] = {50,1},	["H0A2"] = {0,0},	["H0A4"] = {0,0},	["H0A6"] = {0,0},
   ["H0A8"] = {15,4},	["H0AA"] = {40,30},	["H0AC"] = {0,0},	["H0AE"] = {0,0},	["H0B0"] = {50,132},	["H0B2"] = {0,0},
   ["H0B4"] = {0,0},	["H0B6"] = {0,0},	["H0B8"] = {0,0},	["H0BA"] = {10,2},	["H0BC"] = {50,168},	["H0BE"] = {50,30},
   ["H0C0"] = {50,1},	["H0C2"] = {50,180},	["H0C4"] = {0,0},	["H0C6"] = {0,0},	["H0C8"] = {50,16},	["H0CA"] = {0,0},
   ["H0CC"] = {0,0},	["H0CE"] = {0,0},	["H0D0"] = {50,84},	["H0D2"] = {0,0},	["H0D4"] = {0,0},	["H0D6"] = {0,0},
   ["H0D8"] = {0,0},	["H0DA"] = {0,0},	["H0DC"] = {10,2},	["H0DE"] = {50,140},	["H0E0"] = {50,2},	["H0E2"] = {10,1},
   ["H0E4"] = {0,0},	["H0E6"] = {0,0},	["H0E8"] = {50,12},	["H0EA"] = {0,0},	["H0EC"] = {0,0},	["H0EE"] = {0,0},
   ["H0F0"] = {50,8},	["H0F2"] = {50,84},	["H0F4"] = {50,6},	["H0F6"] = {50,14},	["H0F8"] = {50,2},	["H0FA"] = {50,2},
   ["H0FC"] = {50,2},	["H0FE"] = {50,2},	["H100"] = {50,1},	["H102"] = {50,2},	["H104"] = {50,1},	["H106"] = {50,2},
   ["H108"] = {50,7},	["H10A"] = {50,6},	["H10C"] = {50,60},	["H10E"] = {50,60},	["H110"] = {50,180},	["H112"] = {0,0},
   ["H114"] = {0,0},	["H116"] = {0,0},	["H118"] = {0,0},	["H11A"] = {0,0},	["H11C"] = {10,18},	["H11E"] = {50,180},
   ["H120"] = {50,2},	["H122"] = {0,0},	["H124"] = {0,0},	["H126"] = {0,0},	["H128"] = {0,0},	["H12A"] = {0,0},
   ["H12C"] = {0,0},	["H12E"] = {0,0},	["H130"] = {50,102},	["H132"] = {0,0},	["H134"] = {0,0},	["H136"] = {0,0},
   ["H138"] = {0,0},	["H13A"] = {0,0},	["H13C"] = {50,168},	["H13E"] = {50,42},	["H140"] = {50,1},	["H142"] = {50,180},
   ["H144"] = {10,2},	["H146"] = {0,0},	["H148"] = {10,1},	["H14A"] = {0,0},	["H14C"] = {0,0},	["H14E"] = {10,14},
   ["H150"] = {50,120},	["H152"] = {0,0},	["H154"] = {15,30},	["H156"] = {0,0},	["H158"] = {0,0},	["H15A"] = {0,0},
   ["H15C"] = {0,0},	["H15E"] = {50,132},	["H160"] = {50,2},	["H162"] = {0,0},	["H164"] = {0,0},	["H166"] = {0,0},
   ["H168"] = {50,8},	["H16A"] = {0,0},	["H16C"] = {0,0},	["H16E"] = {0,0},	["H170"] = {50,4},	["H172"] = {45,186},
   ["H174"] = {25,20},	["H176"] = {35,40},	["H178"] = {50,168},	["H17A"] = {50,84},	["H17C"] = {50,12},	["H17E"] = {50,6},
   ["H180"] = {50,1},	["H182"] = {50,180},	["H184"] = {50,12},	["H186"] = {50,36},	["H188"] = {35,30},	["H18A"] = {25,12},
   ["H18C"] = {30,90},	["H18E"] = {50,168},	["H190"] = {50,180},	["H192"] = {0,0},	["H194"] = {0,0},	["H196"] = {0,0},
   ["H198"] = {0,0},	["H19A"] = {0,0},	["H19C"] = {0,0},	["H19E"] = {50,136},	["H1A0"] = {50,1},	["H1A2"] = {0,0},
   ["H1A4"] = {0,0},	["H1A6"] = {0,0},	["H1A8"] = {50,4},	["H1AA"] = {10,30},	["H1AC"] = {0,0},	["H1AE"] = {25,12},
   ["H1B0"] = {50,168},	["H1B2"] = {0,0},	["H1B4"] = {0,0},	["H1B6"] = {0,0},	["H1B8"] = {0,0},	["H1BA"] = {10,6},
   ["H1BC"] = {50,60},	["H1BE"] = {50,6},	["H1C0"] = {50,1},	["H1C2"] = {50,180},	["H1C4"] = {0,0},	["H1C6"] = {0,0},
   ["H1C8"] = {50,48},	["H1CA"] = {0,0},	["H1CC"] = {0,0},	["H1CE"] = {10,6},	["H1D0"] = {50,168},	["H1D2"] = {0,0},
   ["H1D4"] = {0,0},	["H1D6"] = {0,0},	["H1D8"] = {15,6},	["H1DA"] = {0,0},	["H1DC"] = {10,4},	["H1DE"] = {50,88},
   ["H1E0"] = {50,2},	["H1E2"] = {10,1},	["H1E4"] = {0,0},	["H1E6"] = {0,0},	["H1E8"] = {50,132},	["H1EA"] = {0,0},
   ["H1EC"] = {0,0},	["H1EE"] = {0,0},	["H1F0"] = {50,2},	["H1F2"] = {50,42},	["H1F4"] = {50,6},	["H1F6"] = {50,6},
   ["H1F8"] = {50,2},	["H1FA"] = {50,2},	["H1FC"] = {50,2},	["H1FE"] = {50,2}
}
------------------------------------------------------------------------------------------------
-- 'END_TYPE' must be "BREAK", "BREAK4", "CHAOS" or "OSC" or "OLDOSC"

--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      comProcs.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   local valid = true
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = {"R"}
   end
   if  scriptFileData.END_TYPE then
      valid =  ( scriptFileData.END_TYPE:sub(1,5) == "BREAK" ) or
               ( scriptFileData.END_TYPE == "CHAOS" ) or 
               ( scriptFileData.END_TYPE == "OLDCHAOS" ) or 
               ( scriptFileData.END_TYPE == "OLDOSC" ) or 
               ( scriptFileData.END_TYPE == "OSC" )
   end
   return valid
end



--==============================================================================

local function doFINDpopRes(outFile, rule, geo, wv, hv, seed, gen, oscPeriod, pop, res)
   outFile:write(string.format("%s,%s,%s,%s,%s,%s,%s,%i,%s\n",
                               rule, geo:sub(1,2), wv, hv, seed, gen, oscPeriod, pop, res))
   outFile:flush()                                
end
--------------------------------------------------------------------------------
function saveResults(typeOR)
   --   key = rule..':'..geo:sub(1,2)..':'..tostring(hv)..':'..tostring(wv)..':'..seed
   --   m.linesDone[key] = {gen, period, type}
   m.cnt = m.cnt + 1
   logFile:write("saveResults call "..m.cnt..'\n')
   local a = false; for k in pairs(m.linesDone) do a = true; break end  -- test that m.linesDone is not empty
   if m.outFile and a and ((scriptFileData.SAVE_OTHER) or (typeOR == "override") ) then
      local keyPart
      for key in pairs(m.linesDone) do
         keyPart = {}
         for word in string.gmatch(key, "[^:]+") do
            keyPart[#keyPart + 1] = word
         end
         if ((#keyPart == 5) and (#m.linesDone[key] == 4)) then
              doFINDpopRes(m.outFile, keyPart[1], keyPart[2], keyPart[3], keyPart[4], keyPart[5], m.linesDone[key][1], m.linesDone[key][2], m.linesDone[key][3], m.linesDone[key][4])
              m.linesDone[key] = nil
         else
            logFile:write("** saveResults: either key "..key.." does not have 5 parts or linesDone[key] "..#m.linesDone[key].." does not have 4 parts\n")
         end
      end
      m.outFile:close(); m.outFile = nil
   end
end

--------------------------------------------------------------------------------

function openOutFile()
   local res = false
   local words = {}
   local key
   local inFile
   local test = true
   m.linesDone = {}
   logFile:write(' openOutFile\n')
   if scriptFileData then
      inFile = io.open ( scriptFileData.RESULTS_NEW , "r")
      if inFile then
         m.outFile = io.open ( scriptFileData.RESULTS_OLD , "w")
         if m.outFile then
            local line = inFile:read("*l")
            while line do
               m.outFile:write(line..'\n')
               line = inFile:read("*l")
            end
            inFile:close(); inFile = nil
            m.outFile:close(); m.outFile = nil
            m.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
            inFile = io.open ( scriptFileData.RESULTS_OLD , "r")
            if m.outFile and inFile then
               local line = inFile:read("*l")
               while line do
                  if (line:sub(1,4) ~= "RULE") then
                     words = split(line)
                     if #words == 9 then
                        key = words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]
                        if  (m.linesDone[key]) and (words[9] == 'maxEx') then
                           if (m.linesDone[key][4] ~= 'end') and 
                                ( 
                                  (tonumber(words[6]) > tonumber(m.linesDone[key][1])) or
                                  (tonumber(words[7]) < tonumber(m.linesDone[key][2])) or 			-- for maxEx period is negative
                                  (tonumber(words[7]) > 0 )  			-- for maxEx period is negative
                                ) 
                            then
                               logFile:write('m.linesDone changed '..m.linesDone[key][1]..'->'..words[6]..' \n')
                               m.linesDone[key] = {words[6],words[7],words[8],words[9]}
                           end
                        else
                           m.linesDone[key] = {words[6],words[7],words[8],words[9]}	-- gen, period, pop, type
                        end
                     else
                        logFile:write('openOutFile line '..line..' not 9 words\n')
                     end                     
                  end
                  line = inFile:read("*l")
               end 
               logFile:write('m.linesDone collected '..#m.linesDone..'\n')
               res = true
            else
               logFile:write("openOutFile (2nd) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(m.outFile).."\n")
               res = false
               m.outFile:close(); m.outFile = nil
            end
            inFile:close(); inFile = nil
         else
            logFile:write("openOutFile (1st) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(outFile).."\n")
            comProcs.report.collect('no RESULTS_OLD',false)
            inFile:close(); inFile = nil
            res = false
         end         
      else
         logFile:write("openOutFile no old file to copy\n")
         m.outFile = io.open(scriptFileData.RESULTS_NEW, "w")
         res = m.outFile ~= nil
      end
   else
      logFile:write("openOutFile no script file data\n")
      res = false
   end
   if (res) then
      m.outFile:write("RULE,GEO,WD,HT,SEED,GEN,PERIOD,POP,TYPE\n")
   end
   return res
end

------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.run(segmentNo)
   logFile:write('\ndoFINDEND-n\n')
   local test =true
   local logDiverted
   g.show('Find End Started')
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      if ( openOutFile() ) then
         local OldOnly = true
         m.GetSamples(OldOnly)
         OldOnly = false
         m.GetSamples(OldOnly)
      end
   else
     comProcs.showTextOV('No Script file Loaded')
   end
   g.show('Finished')
   if (m.outFile ~= nil) then
      m.outFile:close();
      m.outFile = nil
   else
      comProcs.showTextOV('\nProblems copying old data\n')
   end
end
------------------------------------------------------------
-- use as FindEnd

function m.FindEnd_OSC(seed, maxGen, step1, minOsc, maxOsc)
   logFile:write("FindEnd_OSC_VP\n")
   local res = gs.doFindEnd(seed, maxGen, step1, minOsc, maxOsc)
   return ({res = res, oscPeriod = gs.oscPeriod, pop = gs.pop})
end
------------------------------------------------------------
-- use as FindEnd

function m.FindEnd_Band(seed, maxGen, step1, minOsc, maxOsc)
   logFile:write("FindEnd_VP_BRK\n")
   gsb.init(logFile, scriptFileData.END_TYPE)
   local res = gsb.doFindEnd(seed, maxGen, step1)
   g.show(res)
   return ({res = gsb.result, oscPeriod = gsb.oscPeriod, pop = g.getpop()})
end
------------------------------------------------------------
-- use as FindEnd

function m.FindEnd_Chaos(seed, maxGen, step1, minOsc, maxOsc)
   logFile:write("FindEnd_VP_Chaos\n")
   gsc.init(logFile)
   local res = gsc.doFindEnd(seed, maxGen, step1)
   return ({res = res, oscPeriod = -1, pop = g.getpop()})
end
------------------------------------------------------------
-- use as FindEnd

function m.FindEnd(seed, maxGen, step1, minOsc, maxOsc)
   logFile:write("FindEnd\n")
   gs.init(logFile)
   local res = gs.doFindEnd(seed, maxGen, step1, minOsc, maxOsc )
   return ({res = res, oscPeriod = gs.oscPeriod, pop = g.getpop()})
end
------------------------------------------------------------

function m.GetSamples(OldOnly)
--------------------------------------------------------------------------
   local rule, seed, geo, hv, wv, maxCells
   local verify = scriptFileData.VERIFY
   local check_max_gen = scriptFileData.CHECK_MAX_GEN
   logFile:write("verify "..comProcs.bool2txt(verify).."\n")
   if ( scriptFileData.END_TYPE and ( (scriptFileData.END_TYPE:sub(1,5) == "BREAK")
                                   or (scriptFileData.END_TYPE == "CHAOS") )) then
      logFile:write("FindEnd_VP_Band\n")
      FindEnd = m.FindEnd_Band
   elseif ( scriptFileData.END_TYPE and (scriptFileData.END_TYPE == "OLDCHAOS")) then
      logFile:write("FindEnd_VP_Chaos\n")
      FindEnd = m.FindEnd_VP_Chaos
   else
      logFile:write("FindEnd\n")
      FindEnd = m.FindEnd
   end
   function runOne(wv,hv,geo, rMaxWD, maxOscP)
      local res
      local step1 =  scriptFileData.STEP1
      local doIt = true
      local key = rule..':'..geo:sub(1,2)..':'..tostring(hv)..':'..tostring(wv)..':'..seed
      local endstr = 'none'
      local maxGen = scriptFileData.MAX_GEN
      local maxOsc = math.min(scriptFileData.MAX_OSC, maxOscP)
      local minOsc = scriptFileData.MIN_OSC
      if (m.linesDone[key]) then
         doIt = (verify and (m.linesDone[key][4] == 'end') )
             or (check_max_gen and (m.linesDone[key][4] == 'maxEx')
                               and ( (tonumber(m.linesDone[key][1]) < maxGen)
                                     or (-tonumber(m.linesDone[key][2]) < maxOsc)
                                   )
                )
             or (m.linesDone[key][4] == 'killed')
         if(not doIt and OldOnly) then
            doFINDpopRes(m.outFile, rule, geo, wv, hv, seed, m.linesDone[key][1], m.linesDone[key][2], m.linesDone[key][3],m.linesDone[key][4])
         else
            logFile:write("dataOK "..m.linesDone[key][1]..","..m.linesDone[key][2]..","..m.linesDone[key][3]..","..m.linesDone[key][4].."\n")
            doFINDpopRes(logFile, rule, geo, wv, hv, seed, m.linesDone[key][1], m.linesDone[key][2], m.linesDone[key][3], m.linesDone[key][4])
            if (verify) and (m.linesDone[key][4] == 'end') then
               maxGen = tonumber(m.linesDone[key][1])+100
               maxOsc = tonumber(m.linesDone[key][2])+10
               minOsc = 1
            end
            step1 = math.max( 0,math.min( tonumber(m.linesDone[key][1]),maxGen)*0.6  )
            logFile:write("Step1 ",step1,"; end type "..m.linesDone[key][4]..' doIt '..comProcs.bool2txt(doIt)..' verify '..comProcs.bool2txt(verify)..'\n')
         end
      end
      if (not OldOnly) then
         if (doIt) then
            if (m.linesDone[key]) and (check_max_gen) and (tonumber(m.linesDone[key][2]) > 0) and (tonumber(m.linesDone[key][1]) > maxGen) then
               maxGen = tonumber(m.linesDone[key][1])
            end
            gr.doBuild(' SymCACP FindEnd ', wv, hv, seed, geo, rule)  -- w, h, seed, rule, format
            local found = {}
            g.show(rMaxWD)
            g.show(maxOsc)
            if( (wv <= rMaxWD) and (maxOsc > 0 )) then 
               found = FindEnd(seed, maxGen, step1, minOsc, maxOsc)
            else            
               local event = g.getevent()
               if (event:find("^key") or event:find("^oclick"))  then
                  logFile:write("VP stoped by user action gen \n")
                  found.res ="killed"
                  found.oscPeriod =-1
                  found.pop =-1
               else
                  g.run(scriptFileData.MAX_GEN)
                  local pop = tonumber(g.getpop())
                  found.pop = math.min(pop, maxCells - pop)
                  found.res = "maxEx"
               end               
            end
            res = found.res
            if (res ~= 'killed') or (not m.linesDone[key]) then
               if (res ~= 'killed') then
                  g.show(res..' seed '..seed..' gen '..tonumber(g.getgen()))
               end
               if ( res == "maxEx") then 
                  doFINDpopRes(m.outFile, rule, geo, wv, hv, seed, tonumber(g.getgen()), -maxOsc, found.pop, res)
               else
                  doFINDpopRes(m.outFile, rule, geo, wv, hv, seed, tonumber(g.getgen()), found.oscPeriod, found.pop, res)
               end
               m.linesDone[key] = nill
            end
         end
      end
      return res
   end
   
   local res = ''
   for wv = scriptFileData.WIDTH0,scriptFileData.WIDTH1,scriptFileData.WIDTHS do
      maxCells = wv * wv
      for ir = 1,#scriptFileData.RULES do
         rule = scriptFileData.RULES[ir]
         local rMaxWD = m.ruleData[rule][1]+5
         local rMaxPer = (m.ruleData[rule][2]*3+3)//4
         logFile:write("RunOne rule "..rule.." wd: "..rMaxWD.." Per: "..rMaxPer.."\n")
         g.new('SymCACP Script '..scriptFileData.RESULTS_NEW..' '..rule..' ')
         for geoI,geo in pairs(scriptFileData.GEO) do
            g.show("width "..scriptFileData.WIDTH0..","..scriptFileData.WIDTH1..","..scriptFileData.WIDTHS)
            for is = 1,#scriptFileData.SEEDS do
               seed = scriptFileData.SEEDS[is]
               res = runOne(wv,wv,geo, rMaxWD, rMaxPer)
               if res == 'killed' then break end
            end
            m.outFile:flush()
            if res == 'killed' then break end
         end
         if res == 'killed' then break end
      end
      if res == 'killed' then break end
   end
   if ((not OldOnly) and logDiverted) then
      logFile:flush()
      reDivertLog()
   end
end
return m
------------------------------------------------------------
